<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Configuración robusta para bases de datos
try {
    $codesDB = new SQLite3('./api/codes_rgvip.db');
    $db = new SQLite3('./api/.db.db');
    
    // Configuración de conexión
    $codesDB->busyTimeout(5000);
    $db->busyTimeout(5000);
    $codesDB->exec("PRAGMA journal_mode = WAL");
    $db->exec("PRAGMA journal_mode = WAL");
} catch (Exception $e) {
    die("Error al conectar con las bases de datos: " . $e->getMessage());
}

// Crear tabla si no existe (estructura mejorada)
$codesDB->exec('CREATE TABLE IF NOT EXISTS activation_codes (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    mac_address TEXT NOT NULL CHECK(length(mac_address) > 0),
    username TEXT NOT NULL CHECK(length(username) > 0),
    password TEXT NOT NULL CHECK(length(password) > 0),
    dns_id INTEGER NOT NULL,
    dns_url TEXT NOT NULL,
    cliente_nombre TEXT NOT NULL CHECK(length(cliente_nombre) > 0),
    cliente_whatsapp TEXT NOT NULL CHECK(length(cliente_whatsapp) > 0),
    expiracion TEXT NOT NULL CHECK(date(expiracion) IS NOT NULL),
    code TEXT UNIQUE NOT NULL CHECK(length(code) = 12),
    used INTEGER DEFAULT 0 CHECK(used IN (0,1)),
    created_at TEXT DEFAULT CURRENT_TIMESTAMP,
    is_protected INTEGER DEFAULT 0 CHECK(is_protected IN (0,1))
)');

// Variables para mostrar modal
$codigoGenerado = null;
$macGenerada = null;
$mostrarModal = false;
$error = null;

// Función para generar código (mejorada)
function generarCodigo() {
    $bytes = random_bytes(6);
    return strtoupper(bin2hex($bytes));
}

// Función para validar MAC (entre 3 y 8 pares separados por : o -)
function validarMAC($mac) {
    return preg_match('/^([0-9A-Fa-f]{2}[:-]){2,7}[0-9A-Fa-f]{2}$/', $mac);
}
// Quita espacios y valida que empiece con un código de país (con o sin +) y tenga entre 10 y 15 dígitos
function validarWhatsApp($numero) {
    return preg_match('/^\+?[1-9][0-9]{7,14}$/', $numero);
}

// Procesar formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['generate'])) {
    try {
        // Validación y saneamiento de datos
$mac = strtoupper(trim($_POST['mac_address']));
if (!validarMAC($mac)) {
    throw new Exception("Formato de MAC address inválido. Debe tener entre 3 y 8 pares hexadecimales separados por : o -");
}

        $username = trim($_POST['username']);
        if (strlen($username) < 3 || strlen($username) > 20) {
            throw new Exception("El usuario debe tener entre 3 y 20 caracteres");
        }
        
        $password = trim($_POST['password']);
        if (strlen($password) < 4) {
            throw new Exception("La contraseña debe tener al menos 4 caracteres");
        }
        
        $dns_id = intval($_POST['dns_id']);
        if ($dns_id <= 0) {
            throw new Exception("Seleccione un DNS válido");
        }
        
        $expiracion = trim($_POST['expiracion']);
        if (!preg_match('/^\d{4}-\d{2}-\d{2}$/', $expiracion) || strtotime($expiracion) < time()) {
            throw new Exception("Fecha de expiración inválida o en el pasado");
        }
        
        $nombre_cliente = trim($_POST['cliente_nombre']);
        if (strlen($nombre_cliente) < 2 || strlen($nombre_cliente) > 50) {
            throw new Exception("El nombre del cliente debe tener entre 2 y 50 caracteres");
        }
        $cliente_whatsapp = trim($_POST['cliente_whatsapp']);
        if (strpos($cliente_whatsapp, '+') !== 0) {
        $cliente_whatsapp = '+' . $cliente_whatsapp;
        }

        if (!validarWhatsApp($cliente_whatsapp)) {
        throw new Exception("Número de WhatsApp inválido. Debe incluir código de país (ej: 523331182896)");
        }
        
        $is_protected = isset($_POST['is_protected']) ? 1 : 0;
        $created_at = date('Y-m-d H:i:s');
        $code = generarCodigo();

        // Obtener DNS URL con transacción
        $codesDB->exec('BEGIN TRANSACTION');
        
        $dnsQuery = $db->prepare("SELECT url FROM dns WHERE id = :id");
        $dnsQuery->bindValue(':id', $dns_id, SQLITE3_INTEGER);
        $dnsResult = $dnsQuery->execute();
        $dnsRow = $dnsResult->fetchArray(SQLITE3_ASSOC);
        
        if (!$dnsRow) {
            throw new Exception("El DNS seleccionado no existe");
        }
        $dns_url = $dnsRow['url'];

        // Insertar código con consulta preparada
        $stmt = $codesDB->prepare("INSERT INTO activation_codes 
            (mac_address, username, password, dns_id, dns_url, cliente_nombre, cliente_whatsapp, expiracion, code, created_at, is_protected) 
            VALUES (:mac, :username, :password, :dns_id, :dns_url, :nombre_cliente, :cliente_whatsapp, :expiracion, :code, :created_at, :is_protected)");
        
        $stmt->bindValue(':mac', $mac, SQLITE3_TEXT);
        $stmt->bindValue(':username', $username, SQLITE3_TEXT);
        $stmt->bindValue(':password', $password, SQLITE3_TEXT);
        $stmt->bindValue(':dns_id', $dns_id, SQLITE3_INTEGER);
        $stmt->bindValue(':dns_url', $dns_url, SQLITE3_TEXT);
        $stmt->bindValue(':nombre_cliente', $nombre_cliente, SQLITE3_TEXT);
        $stmt->bindValue(':cliente_whatsapp', $cliente_whatsapp, SQLITE3_TEXT);
        $stmt->bindValue(':expiracion', $expiracion, SQLITE3_TEXT);
        $stmt->bindValue(':code', $code, SQLITE3_TEXT);
        $stmt->bindValue(':created_at', $created_at, SQLITE3_TEXT);
        $stmt->bindValue(':is_protected', $is_protected, SQLITE3_INTEGER);

        if (!$stmt->execute()) {
            throw new Exception("Error al guardar el código: " . $codesDB->lastErrorMsg());
        }
        
        $codesDB->exec('COMMIT');
        
        $codigoGenerado = $code;
        $macGenerada = $mac;
        $mostrarModal = true;

        // URL de activación
        $protocolo = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
        $host = $_SERVER['HTTP_HOST'];
        $path = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\');
        $urlActivar = $protocolo . $host . $path . '/activar.php';
        // Obtener URL completa para activar_publico.php
        $urlActivarPublico = $protocolo . $host . $path . '/activar_publico.php';
        // WhatsApp mensaje
        $mensajeWhatsApp = urlencode("🎉 ¡Código de activación generado! 🎯\n\n🔐 *Código:* $codigoGenerado\n🖥️ *MAC:* $macGenerada\n\n✅ Ve a la página de activación:\n$urlActivarPublico");
        
    } catch (Exception $e) {
        $codesDB->exec('ROLLBACK');
        $error = $e->getMessage();
    }
}

// Obtener opciones de DNS
$dnsOptions = [];
try {
    $result = $db->query("SELECT id, title FROM dns ORDER BY title");
    while ($row = $result->fetchArray(SQLITE3_ASSOC)) {
        $dnsOptions[] = $row;
    }
} catch (Exception $e) {
    $error = "Error al cargar opciones de DNS: " . $e->getMessage();
}

$db->close();
$codesDB->close();

include 'includes/header.php';
?>
        <?php if ($error): ?>
        <div class="alert alert-danger alert-dismissible fade show">
            <strong>Error:</strong> <?= htmlspecialchars($error) ?>
            <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
        <?php endif; ?>
         <h1 class="title-outside-card mb-1 text-center">🎯 Generar Códigos</h1>
        <div class="mx-auto" style="max-width: 900px;">
        <div class="card bg-dark text-white">
            <div class="card-header py-2">
                <h6 class="m-0 font-weight-bold text-primary"><i class="fas fa-key"></i> Generar Nuevo Código</h6>
            </div>
            <?php if ($mostrarModal && $codigoGenerado && $macGenerada): ?>
            <!-- Modal de éxito -->
            <div class="modal fade" id="codigoModal" tabindex="-1" role="dialog" aria-hidden="true">
              <div class="modal-dialog" role="document">
                <div class="modal-content border-success">
                  <div class="modal-header bg-success text-white">
                    <h5 class="modal-title">✅ ¡Código generado con éxito!</h5>
                    <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
                  </div>
                  <div class="modal-body text-center">
                    <div class="alert alert-info">
                        <p>🔑 <strong>Código:</strong> <span id="codigoGenerado"><?= htmlspecialchars($codigoGenerado) ?></span></p>
                        <p>🖥️ <strong>MAC:</strong> <?= htmlspecialchars($macGenerada) ?></p>
                    </div>
                    <div class="d-flex justify-content-center flex-wrap mt-3">
                      <button class="btn btn-outline-primary m-1" onclick="copiarCodigo()">
                        <i class="fas fa-copy"></i> Copiar código
                      </button>
                      <a class="btn btn-success m-1" target="_blank" href="https://wa.me/<?= htmlspecialchars($_POST['cliente_whatsapp']) ?>?text=<?= $mensajeWhatsApp ?>">
                        <i class="fab fa-whatsapp"></i> Enviar WhatsApp
                      </a>
                      <a class="btn btn-info m-1" href="<?= $urlActivar ?>">
                        <i class="fas fa-rocket"></i> Activar
                      </a>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <script>
            $(document).ready(function() {
                $('#codigoModal').modal('show');
                
                // Cerrar modal al hacer clic fuera
                $('#codigoModal').modal({backdrop: 'static', keyboard: false});
            });
            
            function copiarCodigo() {
                const codigo = document.getElementById("codigoGenerado").innerText;
                navigator.clipboard.writeText(codigo).then(() => {
                    const originalText = $('.btn-outline-primary i').attr('class');
                    $('.btn-outline-primary i').removeClass().addClass('fas fa-check');
                    setTimeout(() => {
                        $('.btn-outline-primary i').removeClass().addClass(originalText);
                    }, 2000);
                });
            }
            </script>
            <?php endif; ?>

            <div class="card-body">
  <form method="post" id="formGenerador">
    <input type="hidden" name="generate" value="1">

    <div class="row">
      <div class="form-group col-md-6">
        <label for="mac_address">Dirección MAC</label>
        <input type="text" id="mac_address" name="mac_address" class="form-control mac-input"
          required
          pattern="^([0-9A-Fa-f]{2}[:-]){2,7}[0-9A-Fa-f]{2}$"
          title="Introduce una dirección MAC con entre 3 y 8 pares hexadecimales.">
      </div>

      <div class="form-group col-md-6">
        <label for="username">Usuario</label>
        <input type="text" id="username" name="username" class="form-control"
          required minlength="3" maxlength="20">
      </div>

      <div class="form-group col-md-6">
        <label for="password">Contraseña</label>
        <input type="text" id="password" name="password" class="form-control"
          required minlength="4">
      </div>

      <div class="form-group col-md-6">
        <label for="dns_id">Servidor DNS</label>
        <select class="form-control" id="dns_id" name="dns_id" required>
          <option value="">Seleccione un servidor...</option>
          <?php foreach($dnsOptions as $dns): ?>
          <option value="<?= $dns['id'] ?>"><?= htmlspecialchars($dns['title']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="form-group col-md-6">
        <label for="cliente_nombre">Nombre del Cliente</label>
        <input type="text" id="cliente_nombre" name="cliente_nombre" class="form-control"
          required minlength="2" maxlength="50">
      </div>

      <div class="form-group col-md-6">
        <label for="cliente_whatsapp">WhatsApp (con código de país)</label>
        <input type="text" id="cliente_whatsapp" name="cliente_whatsapp" class="form-control"
          placeholder="Ej: 523331182896 "
          required
          pattern="^\+?\d{7,15}$"
          title="Ingrese número con código de país, con o sin '+' (ej: 573001234567 o +573001234567)">
      </div>

      <div class="form-group col-md-6">
        <label for="expiracion">Fecha de Expiración</label>
        <input type="date" id="expiracion" name="expiracion" class="form-control"
          required min="<?= date('Y-m-d') ?>">
      </div>

      <div class="form-group col-md-6 d-flex align-items-center">
        <div class="form-check mt-4">
          <input type="checkbox" class="form-check-input" id="is_protected" name="is_protected" value="1">
          <label class="form-check-label" for="is_protected">
            <i class="fas fa-lock"></i> Proteger lista (evitar modificaciones en la app)
          </label>
        </div>
      </div>
    </div>

    <button type="submit" class="btn btn-primary btn-block mt-3">
      <i class="fas fa-key"></i> Generar Código
    </button>
  </form>
</div>


<script>
$(document).ready(function() {
    // Formateador de MAC address: permite hasta 8 pares (16 caracteres hexadecimales)
    $('.mac-input').on('input', function(e) {
        let value = e.target.value.replace(/[^a-fA-F0-9]/g, "").toUpperCase();
        let formatted = "";
        for (let i = 0; i < value.length && i < 16; i++) {
            formatted += value[i];
            if ((i + 1) % 2 === 0 && i < value.length - 1) {
                formatted += ":";
            }
        }
        e.target.value = formatted;
    });

    // Validación del formulario
    $('#formGenerador').on('submit', function() {
        const mac = $('#mac_address').val();

        // Validar de 3 a 8 pares hexadecimales separados por : o -
        const macRegex = /^([0-9A-F]{2}[:-]){2,7}([0-9A-F]{2})$/i;
        if (!macRegex.test(mac)) {
            alert('Por favor ingrese una dirección MAC válida (entre 3 y 8 pares)');
            return false;
        }

        const fecha = new Date($('#expiracion').val());
        const hoy = new Date();
        hoy.setHours(0, 0, 0, 0);

        if (fecha < hoy) {
            alert('La fecha de expiración no puede ser en el pasado');
            return false;
        }

        return true;
    });
});
</script>
<?php include 'includes/footer.php'; ?>