<?php
// Configuración
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__.'/php_errors.log');

// Conexiones
function connectSQLite($path) {
    try {
        $db = new SQLite3($path);
        $db->enableExceptions(true);
        $db->busyTimeout(5000);
        return $db;
    } catch (Exception $e) {
        error_log("Error de conexión: ".$e->getMessage());
        return false;
    }
}

$db = connectSQLite(__DIR__.'/.db.db');
$codesDB = connectSQLite(__DIR__.'/codes_rgvip.db');

if (!$db || !$codesDB) {
    die("<div class='alert alert-danger'>Error al conectar con las bases de datos</div>");
}

// Procesamiento
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['code'])) {
    $code = trim($_POST['code']);

    if (empty($code) || !preg_match('/^[A-Z0-9]{6,20}$/', $code)) {
        exit("<div class='alert alert-danger'>❌ Código inválido</div>");
    }

    try {
        // Buscar el código válido y no usado
        $stmt = $codesDB->prepare("SELECT * FROM activation_codes WHERE code = ? AND used = 0 LIMIT 1");
        $stmt->bindValue(1, $code, SQLITE3_TEXT);
        $data = $stmt->execute()->fetchArray(SQLITE3_ASSOC);

        if ($data) {
            // Insertar en playlist
            $stmt = $db->prepare("INSERT INTO playlist 
                (mac_address, username, password, expiracion, dns_id, cliente_nombre, cliente_whatsapp, is_protected, pin) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");

            $stmt->bindValue(1, strtoupper($data['mac_address']), SQLITE3_TEXT);
            $stmt->bindValue(2, $data['username'], SQLITE3_TEXT);
            $stmt->bindValue(3, $data['password'], SQLITE3_TEXT);
            $stmt->bindValue(4, $data['expiracion'], SQLITE3_TEXT);
            $stmt->bindValue(5, $data['dns_id'], SQLITE3_INTEGER);
            $stmt->bindValue(6, $data['cliente_nombre'] ?? 'Cliente', SQLITE3_TEXT);
            $stmt->bindValue(7, $data['cliente_whatsapp'] ?? '', SQLITE3_TEXT);
            $stmt->bindValue(8, isset($data['is_protected']) ? (int)$data['is_protected'] : 0, SQLITE3_INTEGER);
            $stmt->bindValue(9, '0000', SQLITE3_TEXT); // PIN parental

            if ($stmt->execute()) {
                // Insertar también en subscription
                try {
                    $stmt = $db->prepare("INSERT INTO subscription 
                        (mac_address, username, password, exp_date, status) 
                        VALUES (?, ?, ?, ?, 'active')");

                    $stmt->bindValue(1, strtoupper($data['mac_address']), SQLITE3_TEXT);
                    $stmt->bindValue(2, $data['username'], SQLITE3_TEXT);
                    $stmt->bindValue(3, $data['password'], SQLITE3_TEXT);
                    $stmt->bindValue(4, $data['expiracion'], SQLITE3_TEXT);
                    $stmt->execute();
                } catch (Exception $e) {
                    error_log("No se insertó en subscription: ".$e->getMessage());
                }

                // Marcar código como usado
                $codesDB->exec("UPDATE activation_codes SET used = 1 WHERE code = '".SQLite3::escapeString($code)."'");

                echo "<div class='alert alert-success'>✅ Activación exitosa para MAC: ".htmlspecialchars($data['mac_address'])."</div>";
            } else {
                throw new Exception("Error al insertar en playlist: ".$db->lastErrorMsg());
            }
        } else {
            echo "<div class='alert alert-danger'>❌ Código no válido o ya usado</div>";
        }
    } catch (Exception $e) {
        echo "<div class='alert alert-danger'>❌ Error interno: ".htmlspecialchars($e->getMessage())."</div>";
        error_log("Error en activación pública: ".$e->getMessage());
    }
} else {
    echo "<div class='alert alert-danger'>❌ Petición no válida</div>";
}
