<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Activar Servicio IPTV</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap y FontAwesome -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://kit.fontawesome.com/4fa1f3b6b2.js" crossorigin="anonymous"></script>

    <!-- Estilo personalizado para partículas -->
    <link rel="stylesheet" href="css/rgvip.css">
<script src="https://cdn.jsdelivr.net/npm/particles.js@2.0.0/particles.min.js"></script>
    <style>
        body {
            background: linear-gradient(to right, #0f2027, #203a43, #2c5364);
            color: #fff;
            display: flex;
            align-items: center;
            min-height: 100vh;
        }
        #particles-background {
            position: absolute;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 1; /* por encima del fondo, debajo del contenido */
            pointer-events: none;
        }
        .card {
            background: #1e1e2f;
            border-radius: 1rem;
            padding: 2rem;
            box-shadow: 0 0 15px #00000040;
            color: #333;
        }
        .btn-primary {
            background-color: #2a5298;
            border: none;
        }
        .btn-primary:hover {
            background-color: #1e3c72;
        }
        h3.text-center {
    color: white;
}
label.form-label {
    color: white;
}
    </style>
</head>
<body>
<!-- Fondo de partículas -->
    <div id="particles-js"></div>
    <div class="container position-relative" style="z-index: 10;">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card">
                    <h3 class="text-center mb-4">🔑 Activación de Servicio</h3>

                    <div id="alert" class="alert d-none"></div>

                    <form id="activar-form">
                        <div class="mb-3">
                            <label for="code" class="form-label">Código de Activación</label>
                            <input type="text" class="form-control" id="code" name="code" required placeholder="ingresa tu código">
                        </div>
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="fas fa-play-circle"></i> Activar Servicio
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS y Script personalizado -->
    <script>
        document.getElementById('activar-form').addEventListener('submit', async function(e) {
            e.preventDefault();

            const code = document.getElementById('code').value.trim();
            const alertDiv = document.getElementById('alert');
            alertDiv.classList.add('d-none');
            alertDiv.classList.remove('alert-success', 'alert-danger', 'alert-warning');

            if (!code) {
                alertDiv.textContent = 'Por favor ingrese un código válido.';
                alertDiv.classList.remove('d-none');
                alertDiv.classList.add('alert-danger');
                return;
            }

            const formData = new FormData();
            formData.append('code', code);

            try {
                const response = await fetch('api/activar_public.php', {
                    method: 'POST',
                    body: formData
                });

                const text = await response.text();
                alertDiv.innerHTML = text;
                alertDiv.classList.remove('d-none');
                alertDiv.classList.add(text.includes("✅") ? 'alert-success' : 'alert-danger');
            } catch (error) {
                alertDiv.textContent = 'Error de conexión con el servidor.';
                alertDiv.classList.remove('d-none');
                alertDiv.classList.add('alert-warning');
            }
        });
    </script>
    <!-- Script de partículas -->
    <script src="js/panelrgvip.js"></script>
    <script>
    // Bloquea clic derecho en todo excepto en el campo de entrada
    document.addEventListener('contextmenu', function(e) {
        // Permitir solo en el input (campo de texto)
        if (e.target.tagName === 'INPUT' || e.target.tagName === 'TEXTAREA') {
            return;
        }
        e.preventDefault();
    });

    // Bloquear combinaciones de teclas para ver código
    document.addEventListener('keydown', function(e) {
        if (
            e.key === "F12" || 
            (e.ctrlKey && e.shiftKey && e.key === "I") || 
            (e.ctrlKey && e.shiftKey && e.key === "J") || 
            (e.ctrlKey && e.key === "U") || 
            (e.ctrlKey && e.shiftKey && e.key === "C")
        ) {
            e.preventDefault();
        }
    });
</script>
</body>
</html>
